package com.atlassian.bonnie;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;

public class DirectoryUtil
{
    private static final Logger log = LoggerFactory.getLogger(DirectoryUtil.class);

    /**
     * get a Directory from a path and don't throw a whingy bloody IOException.
     * Upgrade the index version if incompatible with the current version.
     */
    public static Directory getDirectory(File path)
    {
        try
        {
            if (!path.exists() && !path.mkdir())
            {
                throw new IOException("Unable to create index directory '" + path.getAbsolutePath() + "'");
            }

            FSDirectory directory = FSDirectory.open(path);

            return directory;
        }
        catch (IOException e)
        {
            throw new LuceneException(e);
        }
    }
}
