package com.atlassian.bonnie;

import java.io.Serializable;

/**
 * A token by which the AnyTypeObjectDao (for example) can resolve any persistent object. Handle is marker-interface with
 * no required methods, but implementors must follow the contract for the <code>toString</code> method.
 *
 * <p>Handles are used to represent persistent objects in places such as the full-search index, providing a way
 * to go back from some text representation to a full object.
 */
public interface Handle extends Serializable
{
    /**
     * The <code>toString()</code> method of a Handle must be written so that the AnyTypeObjectDao (for example) can
     * resolve the String representation of a Handle back to a Handle object, and thus find the referenced object
     *
     * @return a String representation of this Handle that can be resolved back to the same object.
     */
    String toString();
}
