/*
 * Copyright (c) 2003 by Atlassian Software Systems Pty. Ltd.
 * All rights reserved.
 */
package com.atlassian.bonnie;

/**
 * Indexes the data stored in an object for fast+flexible search querying.
 * To search for an object that has been indexed, use Searcher.
 * @see com.atlassian.bonnie.Searcher
 *
 * @author   Armond Avanes (armond555@yahoo.com)
 */
public interface Indexer
{
    //~ Methods --------------------------------------------------------------------------------------------------------

    public void index(Searchable obj);

    public void unIndex(Searchable obj);

    public void reIndex(Searchable obj);
}
