package com.atlassian.bonnie;

import java.util.concurrent.locks.ReentrantLock;

import com.atlassian.util.profiling.UtilTimerStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Adds logging and profiling to lock and unlock methods.
 */
class LoggingReentrantLock extends ReentrantLock
{
    private final static Logger log = LoggerFactory.getLogger(LoggingReentrantLock.class);
    
    private final String name;

    /**
     * @param name the name of the lock, used for logging and a profiling key
     */
    public LoggingReentrantLock(String name)
    {
        this.name = name;
    }

    @Override
    public void lock()
    {
        if (log.isDebugEnabled())
            log.debug("Acquiring lock: " + name);
        UtilTimerStack.push(getClass().getName() + "." + name);
        super.lock();
    }

    @Override
    public void unlock()
    {
        if (log.isDebugEnabled())
            log.debug("Releasing lock: " + name);
        super.unlock();
        UtilTimerStack.pop(getClass().getName() + "." + name);
    }
}