package com.atlassian.bonnie;

/**
 * Thrown when the search token has expired.
 *
 * In the event of this exception, clients should report a timeout to the user and / or retry the search with a new token.
 */
public class SearchTokenExpiredException extends Exception
{
    private final long searchToken;

    public SearchTokenExpiredException(long searchToken)
    {
        super("Search token has expired: " + searchToken);

        this.searchToken = searchToken;
    }

    public long getSearchToken()
    {
        return searchToken;
    }
}
