/*
 * Copyright (c) 2003 by Atlassian Software Systems Pty. Ltd.
 * All rights reserved.
 */
package com.atlassian.bonnie;

import java.util.Collection;


/**
 * Methods required by the indexing subsystem in order to properly handle object searching.
 */
public interface Searchable
{
    long getId();

    /**
     * When we un-index something (say, a page), we also need to un-index everything
     * contained within that page (comments, attachments), because presumably they're
     * all about to go away.
     */ 
    Collection getSearchableDependants();

    /**
     * Allows an object to tell the search indexer that it is not allowed to be indexed
     */
    boolean isIndexable();
}
