/*
 * Copyright (c) 2003 by Atlassian Software Systems Pty. Ltd.
 * All rights reserved.
 */
package com.atlassian.bonnie.analyzer;

import com.atlassian.bonnie.BonnieConstants;
import org.apache.lucene.analysis.*;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.util.Version;

import java.io.Reader;

/**
 * @deprecated since 6.0. Use StandardAnalyzer instead.
 */
@Deprecated
public class DefaultLuceneAnalyzer extends Analyzer
{
    @Override
    protected TokenStreamComponents createComponents(String fieldName, Reader reader)
    {
        LetterTokenizer tokenizer = new LetterTokenizer(BonnieConstants.LUCENE_VERSION, reader);
        TokenStream result = new LowerCaseFilter(BonnieConstants.LUCENE_VERSION, tokenizer);
        result = new StopFilter(BonnieConstants.LUCENE_VERSION, result, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        result = new PorterStemFilter(result);

        return new TokenStreamComponents(tokenizer, result);
    }

}
