package com.atlassian.bonnie.index;

import org.apache.lucene.document.Document;

/**
 * Converts objects to {@link Document}s. Implementations must be thread-safe.
 */
public interface ObjectToDocumentConverter
{
    /**
     * Converts objects to {@link Document}s.
     *
     * @param o       object to be converted
     * @param context the context in which the object exists. Null if not applicable.
     * @return Document representing the indexable version of the object
     */
    Document convert(Object o, Object context);

    /**
     * Given an object, provide a way of uniquely identifying the object from an index.
     *
     * @return array of identity field name and identity value
     */
    String[] getObjectIdentity(Object o);
}
