package com.atlassian.bonnie.index;

import java.util.Collection;

/**
 * Pops objects off an {@link ObjectQueue}, processes them (via {@link ObjectQueue.Processor},
 * then writes them using {@link BatchOpIndexer.DocumentWritingScheme}.
 */
public final class QueueProcessingRunnableImpl implements QueueProcessingRunnable
{
    private ObjectQueue objectQueue;
    private BatchOpIndexer.DocumentWritingScheme documentWritingScheme;
    private ObjectQueue.Processor processor;

    public QueueProcessingRunnableImpl()
    {
    }

    public QueueProcessingRunnableImpl(ObjectQueue objectQueue, BatchOpIndexer.DocumentWritingScheme documentWritingScheme)
    {
        setObjectQueue(objectQueue);
        setDocumentWritingScheme(documentWritingScheme);
    }

    public final void run()
    {
        Collection collection = null;
        while (true)
        {
            synchronized (objectQueue)
            {
                if (objectQueue.hasMore())
                {
                    collection = objectQueue.pop();
                }
                else break;
            }

            processor.indexCollection(collection, documentWritingScheme);
        }
        documentWritingScheme.runComplete();
    }

    public void setObjectQueue(ObjectQueue objectQueue)
    {
        this.objectQueue = objectQueue;
        this.processor = objectQueue.getProcessor();
    }

    public void setDocumentWritingScheme(BatchOpIndexer.DocumentWritingScheme documentWritingScheme)
    {
        this.documentWritingScheme = documentWritingScheme;
    }
}
