package com.atlassian.bonnie.index;

import com.atlassian.bonnie.ILuceneConnection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

import java.io.IOException;

/**
 * DocumentWritingScheme to write a single object to index.
 */
class SingleDocumentWritingScheme extends BaseDocumentWritingScheme
{
    private ILuceneConnection conn;

    public SingleDocumentWritingScheme(ILuceneConnection conn)
    {
        this.conn = conn;
    }

    public void write(final Document doc)
    {
        conn.withWriter(new ILuceneConnection.WriterAction()
        {
            public void perform(IndexWriter writer) throws IOException
            {
                writer.addDocument(doc);
            }
        });
    }

    public void runComplete()
    {

    }

    public void close(ILuceneConnection conn) throws IOException
    {
        conn.close();
    }
}
