package com.atlassian.bonnie.index;

import com.atlassian.bonnie.ILuceneConnection;

/**
 * Indexes/unindexes single objects.
 */
public interface SingleObjectIndexer
{
    /**
     * Add an object to the index. Calls {@link #unindex} before the object is added.
     *
     * @param o
     */
    void index(Object o);

    /**
     * Remove an object from the index.
     *
     * @param o
     */
    void unindex(Object o);

    void setLuceneConnection(ILuceneConnection luceneConnection);

    void setObjectToDocumentConverter(ObjectToDocumentConverter objectToDocumentConverter);
}
