package com.atlassian.bonnie.index;

import java.util.Collection;
import java.util.Collections;

/**
 * A queue for indexing a single object.
 */
public class SingletonObjectQueue implements ObjectQueue
{
    private Object o;
    private ObjectToDocumentConverter otdc;

    public SingletonObjectQueue(Object o, ObjectToDocumentConverter otdc)
    {
        this.o = o;
        this.otdc = otdc;
    }

    public Collection pop()
    {
        Object toreturn = o;
        this.o = null;
        return Collections.singletonList(toreturn);
    }

    public boolean hasMore()
    {
        return o != null;
    }

    public int size()
    {
        return 1;
    }

    public Processor getProcessor()
    {
        return new Processor()
        {
            public void indexCollection(Collection collection, BatchOpIndexer.DocumentWritingScheme documentWritingScheme)
            {
                documentWritingScheme.write(otdc.convert(collection.toArray()[0], null));
            }
        };
    }
}
