package com.atlassian.bonnie.search;

import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.Searchable;
import org.apache.lucene.document.Document;

/**
 * Creates a Lucene {@link Document} from the supplied {@link Searchable}.
 */
public interface DocumentBuilder
{
	/**
	 * @param searchable
	 * @return a Lucene {@link Document} from the supplied {@link Searchable}.
	 */
	Document getDocument(Searchable searchable);

	/**
	 * @return A {@link com.atlassian.bonnie.Handle} by which the {@link com.atlassian.bonnie.AnyTypeObjectDao} (for example) can resolve any persistent object
	 * @see com.atlassian.bonnie.Handle
	 */
	Handle getHandle(Object obj);
}
