package com.atlassian.bonnie.search;

import com.atlassian.bonnie.Searchable;
import org.apache.lucene.document.Document;

/**
 * This interface is highly coupled to Lucene and may require recompilation of the implementing
 * classes every time the version of lucene is upgraded in Confluence core.
 *
 * To avoid this maintenance, you may want to use the lucene-agnostic
 * com.atlassian.confluence.index.api.Extractor2 interface instead (which is robust against lucene version changes).
 */
public interface Extractor
{
    /**
     * Add fields to the specified document object.
     *
     * @param document the lucene document
     * @param defaultSearchableText
     * @param searchable a searchable to extract text from
     */
    void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable);
}
