package com.atlassian.bonnie.search;

import java.lang.reflect.Method;

/**
 * Unwraps Hibernate proxies reflectively, without adding a compile-time
 * dependency on Hibernate itself.
 */
public class HibernateUnwrapper
{
    private static Method getClassMethod = null;

    static
    {
       ClassLoader classLoader = HibernateUnwrapper.class.getClassLoader();
       try
       {
           Class hibernateClass = classLoader.loadClass("net.sf.hibernate.Hibernate");
           getClassMethod = hibernateClass.getMethod("getClass", Object.class);
       }
       catch (Exception e)
       {
           // ignore, Hibernate is not on the classpath
       }
    }

    /**
     * Gets the true class of an object, trying to use Hibernate's proxy unwrapping
     * tools if available on the classpath.
     * <p></p>
     * Otherwise simply returns the class of the object passed in if Hibernate not
     * on the classpath.
     *
     * @param o The object to examine
     * @return The true class of the object (unwrapping Hibernate proxies etc)
     */
    public static Class<?> getUnderlyingClass(Object o)
    {
        if (getClassMethod == null)
            return o.getClass();
        
        try
        {
            return (Class) getClassMethod.invoke(null, o);
        }
        catch (Exception e)
        {
            return o.getClass();
        }
    }
}
