package com.atlassian.bonnie.search;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class IndexerThreadFactory implements ThreadFactory
{
    private final AtomicInteger count = new AtomicInteger(0);
    private final String name;

    public IndexerThreadFactory()
    {
        this("Indexer");
    }

    public IndexerThreadFactory(String name)
    {
        this.name = name;
    }

    public Thread newThread(Runnable command)
    {
        return new Thread(command, name + ": " + count.incrementAndGet());
    }
}
