package com.atlassian.bonnie.search;

import com.atlassian.bonnie.Searchable;

import java.io.InputStream;
import java.io.IOException;

/**
 * An object representing some searchable file.
 */
public interface SearchableAttachment extends Searchable
{
    /**
     * Gets the MIME content-type of this attachment. If there is no content-type,
     * return "application/x-unknown". Should never return null.
     *
     * @return the MIME content-type of the attachment, or "application/x-unknown"
     *         if the MIME type is unknown
     */
    String getContentType();

    /**
     * Gets the filename of this attachment. If there is no filename, return
     * the empty string. This method should never return null.
     *
     * @return the filename of this attachment, or the empty string if there is
     *         no filename
     */
    String getFileName();

    /**
     * Return the contents of the attachment as an InputStream
     *
     * @return an InputStream set at the start of the attachment's contents.
     */
    InputStream getContentsAsStream() throws IOException;

    /**
     * Return any comment associated with this attachment
     */
    String getComment();

    String getNiceType();

    String getNiceFileSize();

    String getDownloadPath();
}
