package com.atlassian.bonnie.search;

import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;

/**
 * Implement this interface to initialise a searcher. This may include warming
 * up or changing the {@link Similarity} implementation used.
 */
public interface SearcherInitialisation
{
    /**
     * Initialises a newly created {@link IndexSearcher}.
     */
    void initialise(IndexSearcher searcher);
}
