package com.atlassian.bonnie.search.extractor;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;

public class AttachmentMetadataExtractor implements Extractor
{
	/**
	 * This may change, don't consider this part of a public API
	 */
	public static class FieldName
	{
		public static final String NICE_TYPE = "niceType";
		public static final String DOWNLOAD_PATH = "downloadPath";
		public static final String NICE_FILE_SIZE = "niceFileSize";
	}

	public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable)
    {
        if (searchable instanceof SearchableAttachment)
        {
            SearchableAttachment attachment = (SearchableAttachment) searchable;

            if (attachment.getFileName() != null && !"".equals(attachment.getFileName()))
            {
                Field fileNameField = new Field("filename", attachment.getFileName(), Field.Store.YES, Field.Index.ANALYZED);
                document.add(fileNameField);
                document.add(new Field("title", attachment.getFileName(), Field.Store.YES, Field.Index.NO));
            }

            if (attachment.getComment() != null && !"".equals(attachment.getComment()))
            {
                Field commentField = new Field("comment", attachment.getComment(), Field.Store.YES, Field.Index.ANALYZED);
                document.add(commentField);
                defaultSearchableText.append(" ").append(attachment.getComment());
            }

            if (attachment.getNiceType() != null && !"".equals(attachment.getNiceType())) {
                document.add(new Field(FieldName.NICE_TYPE, attachment.getNiceType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }

            if (attachment.getDownloadPath() != null && !"".equals(attachment.getDownloadPath())) {
                document.add(new Field(FieldName.DOWNLOAD_PATH, attachment.getDownloadPath(), Field.Store.YES, Field.Index.NO));
            }

            if (attachment.getNiceFileSize() != null && !"".equals(attachment.getNiceFileSize())) {
                document.add(new Field(FieldName.NICE_FILE_SIZE, attachment.getNiceFileSize(), Field.Store.YES, Field.Index.NO));
            }
        }
    }
}
