package com.atlassian.bonnie.search.extractor.util;

/**
 * StringBuilder with a dynamic length limit.
 * <p>
 * This string builder should reduce OOM error.
 * <p>
 * Instances of this class are not safe for use by multiple threads.
 */
public class DynamicLengthLimitedStringBuilder extends AbstractLengthLimitedStringBuilder
{
    private final LengthLimitProvider lengthLimitProvider;

    /**
     * Constructs a string builder with the specified limit provider.
     * The string builder will silently stop appending strings when the limit is reached.
     *
     * @param lengthLimitProvider Length limit provider.
     */
    public DynamicLengthLimitedStringBuilder(final LengthLimitProvider lengthLimitProvider)
    {
        this(lengthLimitProvider, LIMIT_BEHAVIOUR.SILENT);
    }

    public DynamicLengthLimitedStringBuilder(final LengthLimitProvider lengthLimitProvider, final LIMIT_BEHAVIOUR limitBehaviour)
    {
        super(limitBehaviour);
        this.lengthLimitProvider = lengthLimitProvider;
    }

    @Override
    protected int limit()
    {
        return lengthLimitProvider.limit();
    }

    public interface LengthLimitProvider
    {
        int limit();
    }
}
