package com.atlassian.bonnie.search.extractor.util;

public class StaticLengthLimitedStringBuilder extends AbstractLengthLimitedStringBuilder
{
    private final int maxLength;

    /**
     * Constructs a string builder with the specified maximum length.
     * <p>
     * The string builder will silently stop appending strings when the limit is reached.
     * <p>
     * Instances of this class are not safe for use by multiple threads.
     *
     * @param maxLength Maximum length.
     */
    public StaticLengthLimitedStringBuilder(final int maxLength)
    {
        this(maxLength, LIMIT_BEHAVIOUR.SILENT);
    }

    public StaticLengthLimitedStringBuilder(final int maxLength, final LIMIT_BEHAVIOUR limitBehaviour)
    {
        super(limitBehaviour);
        this.buffer = new StringBuilder(maxLength < 16 ? maxLength : 16);
        this.maxLength = maxLength;
    }

    @Override
    protected int limit()
    {
        return maxLength;
    }
}
