package com.atlassian.bonnie.search.extractor.util;

import java.io.IOException;
import java.io.Writer;

/**
 * Writer that writes to given StringBuilder
 */
public class StringBuilderWriter extends Writer
{
    private final AbstractLengthLimitedStringBuilder sb;

    public StringBuilderWriter(AbstractLengthLimitedStringBuilder sb)
    {
        this.sb = sb;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException
    {
        sb.append(cbuf, off, len);
    }

    @Override
    public void flush()
    {
    }

    @Override
    public void close()
    {
    }

    @Override
    public String toString()
    {
        return sb.toString();
    }
}
