package com.atlassian.bonnie.search.summary;

import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/**
 * Class Excerpt represents a single passage found in the
 * document, with some appropriate regions highlit.
 */
public class Excerpt
{
    Vector passages = new Vector();
    SortedSet tokenSet = new TreeSet();
    int numTerms = 0;

    /**
     */
    public Excerpt()
    {
    }

    /**
     */
    public void addToken(String token)
    {
        tokenSet.add(token);
    }

    /**
     * Return how many unique toks we have
     */
    public int numUniqueTokens()
    {
        return tokenSet.size();
    }

    /**
     * How many fragments we have.
     */
    public int numFragments()
    {
        return passages.size();
    }

    public void setNumTerms(int numTerms)
    {
        this.numTerms = numTerms;
    }

    public int getNumTerms()
    {
        return numTerms;
    }

    /**
     * Add a frag to the list.
     */
    public void add(Summary.Fragment fragment)
    {
        passages.add(fragment);
    }

    /**
     * Return an Enum for all the fragments
     */
    public Enumeration elements()
    {
        return passages.elements();
    }
}
