package com.atlassian.bonnie.search.summary;

import java.util.ArrayList;

/**
 * Originally from org.apache.nutch.searcher.Summary v 0.7 (Revision: <a href="http://svn.apache.org/viewcvs.cgi/lucene/nutch/trunk/src/java/org/apache/nutch/searcher/Summary.java?rev=179640&view=markup">179640</a>)
 * 
 * A document summary dynamically generated to match a query.
 */
public class Summary {

  /** A fragment of text within a summary. */
  public static class Fragment {
    private String text;

    /** Constructs a fragment for the given text. */
    public Fragment(String text) { this.text = text; }

    /** Returns the text of this fragment. */
    public String getText() { return text; }

    /** Returns true iff this fragment is to be highlighted. */
    public boolean isHighlight() { return false; }

    /** Returns true iff this fragment is an ellipsis. */
    public boolean isEllipsis() { return false; }

    /** Returns an HTML representation of this fragment. */
    public String toString() { return text; }

      public boolean equals(Object o)
      {
          if (this == o) return true;
          if (o == null || getClass() != o.getClass()) return false;

          final Fragment fragment = (Fragment) o;

          if (!text.equals(fragment.text)) return false;
          if (isHighlight() != fragment.isHighlight()) return false;
          if (isEllipsis() != fragment.isEllipsis()) return false;

          return true;
      }

      public int hashCode()
      {
          return text.hashCode();
      }
  }

  /** A highlighted fragment of text within a summary. */
  public static class Highlight extends Fragment {
    /** Constructs a highlighted fragment for the given text. */
    public Highlight(String text) { super(text); }

    /** Returns true. */
    public boolean isHighlight() { return true; }
  }

  /** An ellipsis fragment within a summary. */
  public static class Ellipsis extends Fragment {
    /** Constructs an ellipsis fragment for the given text. */
    public Ellipsis() { super(" ... "); }

    /** Returns true. */
    public boolean isEllipsis() { return true; }

    /** Returns an HTML representation of this fragment. */
    public String toString() { return " ... "; }
  }

  private ArrayList fragments = new ArrayList();

  private static final Fragment[] FRAGMENT_PROTO = new Fragment[0];

  /** Constructs an empty Summary.*/
  public Summary() {}

  /** Adds a fragment to a summary.*/
  public void add(Fragment fragment) { fragments.add(fragment); }

  /** Returns an array of all of this summary's fragments.*/
  public Fragment[] getFragments() {
    return (Fragment[])fragments.toArray(FRAGMENT_PROTO);
  }

  /** Returns an HTML representation of this fragment. */
  public String toString() {
    StringBuffer buffer = new StringBuffer();
    for (int i = 0; i < fragments.size(); i++) {
      buffer.append(fragments.get(i));
    }
    return buffer.toString();
  }


}