package com.atlassian.cache.impl;

import com.atlassian.cache.CachedReferenceListener;

/**
 * This interface is designed to support {@code CachedReference} implementations in working with {@code CachedReferenceListener}s.
 * <p>
 * The main usage pattern for which this is designed is to use delegation for add/remove (therefore the listeners are
 * managed by the this interface) and then use notify* methods to create and deliver the actual events.
 */
public interface CachedReferenceListenerSupport<V>
{
    void add(CachedReferenceListener<V> listener, boolean includeValues);
    void remove(CachedReferenceListener<V> listener);

    void notifyEvict(V oldValue);
    void notifySet(V value);
    void notifyReset(V oldValue);

    CachedReferenceListenerSupport EMPTY = new CachedReferenceListenerSupport()
    {
        @Override
        public void add(CachedReferenceListener listener, boolean includeValues)
        {
        }

        @Override
        public void remove(CachedReferenceListener listener)
        {
        }

        @Override
        public void notifyEvict(Object oldValue)
        {
        }

        @Override
        public void notifySet(Object value)
        {
        }

        @Override
        public void notifyReset(Object oldValue)
        {
        }
    };
}
