package com.atlassian.cache.impl;

import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.util.concurrent.LazyReference;

public class ValueCachedReferenceListenerSupport<V> implements CachedReferenceListenerSupport<V>
{
    private final LazyReference<Void> initReference = new LazyReference<Void>()
    {
        @Override
        protected Void create() throws Exception
        {
            init(ValueCachedReferenceListenerSupport.this);
            return null;
        }
    };

    private final CachedReferenceListenerSupport<V> valueListenerSupport =
            new LazyCachedReferenceListenerSupport<V>()
            {
                @Override
                protected void init()
                {
                    initReference.get();
                    initValue(this);
                }
            };

    private final CachedReferenceListenerSupport<V> valuelessListenerSupport =
            new LazyCachedReferenceListenerSupport<V>()
            {
                @Override
                protected void init()
                {
                    initReference.get();
                    initValueless(this);
                }
            };

    protected void init(CachedReferenceListenerSupport<V> actualListenerSupport)
    {
    }

    protected void initValue(CachedReferenceListenerSupport<V> actualListenerSupport)
    {
    }

    protected void initValueless(CachedReferenceListenerSupport<V> actualListenerSupport)
    {
    }

    @Override
    public void add(final CachedReferenceListener<V> listener, final boolean includeValues)
    {
        if (includeValues)
        {
            valueListenerSupport.add(listener, true);
        }
        else
        {
            valuelessListenerSupport.add(listener, false);
        }
    }

    @Override
    public void remove(final CachedReferenceListener<V> listener)
    {
        valueListenerSupport.remove(listener);
        valuelessListenerSupport.remove(listener);
    }

    @Override
    public void notifyEvict(final V oldValue)
    {
        valueListenerSupport.notifyEvict(oldValue);
        valuelessListenerSupport.notifyEvict(null);
    }

    @Override
    public void notifySet(final V value)
    {
        valueListenerSupport.notifySet(value);
        valuelessListenerSupport.notifySet(null);
    }

    @Override
    public void notifyReset(final V oldValue)
    {
        valueListenerSupport.notifyReset(oldValue);
        valuelessListenerSupport.notifyReset(null);
    }
}
