/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.impl;

import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.impl.CacheEntryListenerSupport;
import com.atlassian.cache.impl.CacheEntryNotificationSupport;
import com.atlassian.cache.impl.DefaultCacheEntryEvent;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class DefaultCacheEntryListenerSupport<K, V>
implements CacheEntryListenerSupport<K, V> {
    private final Set<CacheEntryListener<K, V>> listeners = new CopyOnWriteArraySet<CacheEntryListener<K, V>>();
    private final CacheEntryNotificationSupport notificationSupport = CacheEntryNotificationSupport.getInstance();

    @Override
    public void add(CacheEntryListener<K, V> listener, boolean includeValues) {
        this.listeners.add((CacheEntryListener<K, V>)Preconditions.checkNotNull(listener));
    }

    @Override
    public void remove(CacheEntryListener<K, V> listener) {
        this.listeners.remove(Preconditions.checkNotNull(listener));
    }

    @Override
    public void notifyAdd(K key, V value) {
        this.notificationSupport.notifyAdd(this.listeners, new DefaultCacheEntryEvent<K, Object>(key, value, null));
    }

    @Override
    public void notifyEvict(K key, V oldValue) {
        this.notificationSupport.notifyEvict(this.listeners, new DefaultCacheEntryEvent<K, Object>(key, null, oldValue));
    }

    @Override
    public void notifyRemove(K key, V oldValue) {
        this.notificationSupport.notifyRemove(this.listeners, new DefaultCacheEntryEvent<K, Object>(key, null, oldValue));
    }

    @Override
    public void notifyUpdate(K key, V value, V oldValue) {
        this.notificationSupport.notifyUpdate(this.listeners, new DefaultCacheEntryEvent<K, V>(key, value, oldValue));
    }
}

