/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.db;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DelegatingConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseHelper {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void setDatabaseLowerProperty(Properties databaseProperties, ApplicationConfiguration applicationConfig) throws BootstrapException {
        block9: {
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                conn = this.getConnection(databaseProperties);
                st = conn.createStatement();
                String sqlQuery = "select lower('\u00dcbersicht')";
                rs = st.executeQuery(sqlQuery);
                rs.next();
                if (rs.getString(1).equals("\u00dcbersicht")) {
                    applicationConfig.setProperty((Object)"hibernate.database.lower_non_ascii_supported", Boolean.FALSE);
                } else {
                    applicationConfig.setProperty((Object)"hibernate.database.lower_non_ascii_supported", Boolean.TRUE);
                }
                applicationConfig.save();
                this.closeResultSetOrLog(rs);
                this.closeStatementOrLog(st);
                this.closeConnectionOrLog(conn);
            }
            catch (SQLException e) {
                log.info("SQL query could not be excecuted: ", (Throwable)e);
            }
            catch (ConfigurationException e2) {
                log.error("Configuration file could not be saved: ", (Throwable)e2);
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeResultSetOrLog(rs);
                this.closeStatementOrLog(st);
                this.closeConnectionOrLog(conn);
            }
        }
    }

    private void closeConnectionOrLog(Connection conn) {
        try {
            if (conn == null) {
                log.error("Connection was null. We could not successfully connect to the specified database");
            } else {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("Could not close database connection: ", (Throwable)e);
        }
    }

    private void closeStatementOrLog(Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            log.warn("Problem while closing statement", (Throwable)e);
        }
    }

    private void closeResultSetOrLog(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.warn("Problem while closing result set", (Throwable)e);
        }
    }

    public Connection getConnection(Properties databaseProperties) throws SQLException, BootstrapException {
        try {
            final ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)databaseProperties);
            return new DelegatingConnection(connectionProvider.getConnection()){

                @Override
                public void close() throws SQLException {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            connectionProvider.close();
                        }
                        catch (HibernateException e) {
                            log.warn("Problem while closing hibernate connection provider", (Throwable)e);
                        }
                    }
                }
            };
        }
        catch (HibernateException e) {
            throw new BootstrapException(e.getMessage() + ", there may be a configuration problem with your hibernate settings");
        }
    }
}

