/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.config.db;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.bootstrap.BootstrapException;
import com.atlassian.config.db.DatabaseHelper;
import com.atlassian.config.lifecycle.LifecycleContext;
import com.atlassian.config.lifecycle.LifecycleItem;
import com.atlassian.config.lifecycle.LifecycleManager;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLowerPropertyCheck
implements LifecycleItem {
    private static final Logger log = LoggerFactory.getLogger(LifecycleManager.class);
    private AtlassianBootstrapManager bootstrapManager;

    public void setBootstrapManager(AtlassianBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Override
    public void startup(LifecycleContext context) throws Exception {
        Properties databaseProperties = this.bootstrapManager.getHibernateProperties();
        DatabaseHelper databaseHelper = new DatabaseHelper();
        try {
            databaseHelper.setDatabaseLowerProperty(databaseProperties, this.bootstrapManager.getApplicationConfig());
        }
        catch (BootstrapException e) {
            log.error("Exception while checking for lowercasing support of database for non ascii characters: " + e, (Throwable)e);
        }
    }

    @Override
    public void shutdown(LifecycleContext context) throws Exception {
    }
}

