/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EnumBasedEvent<T extends Enum> {
    protected final T data;

    protected EnumBasedEvent(T data) {
        this.data = (Enum)Objects.requireNonNull(data);
    }

    public static <E extends Enum<E>, T> Map<E, T> createMapByEnum(E[] enumValues, Function<E, T> constructor) {
        return Arrays.stream(enumValues).collect(Collectors.toMap(Function.identity(), constructor, (v1, v2) -> v1, LinkedHashMap::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumBasedEvent that = (EnumBasedEvent)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "EnumBasedEvent{data=" + this.data + "}";
    }
}

