/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.user;

import com.atlassian.crowd.attribute.AttributeUtil;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.model.user.BaseImmutableUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ImmutableUserWithAttributes
extends BaseImmutableUser
implements UserWithAttributes {
    private final Map<String, Set<String>> attributes;

    private ImmutableUserWithAttributes(Builder builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public static Builder builder(UserWithAttributes user) {
        return ImmutableUserWithAttributes.builder(user, AttributeUtil.toMap((Attributes)user));
    }

    public static Builder builder(User user, Map<String, Set<String>> attributes) {
        return new Builder(user, attributes);
    }

    @Nonnull
    public Set<String> getValues(String key) {
        return this.attributes.getOrDefault(key, Collections.emptySet());
    }

    @Nullable
    public String getValue(String key) {
        return this.getValues(key).stream().findFirst().orElse(null);
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public ImmutableUserWithAttributes withName(String name) {
        return (ImmutableUserWithAttributes)ImmutableUserWithAttributes.builder(this).name(name).build();
    }

    public static class Builder
    extends BaseImmutableUser.Builder<ImmutableUserWithAttributes> {
        private Map<String, Set<String>> attributes;

        public Builder(User user, Map<String, Set<String>> attributes) {
            super(user);
            this.setAttributes(attributes);
        }

        public Builder setAttributes(Map<String, Set<String>> attributes) {
            this.attributes = new HashMap<String, Set<String>>(attributes);
            return this;
        }

        @Override
        public ImmutableUserWithAttributes build() {
            return new ImmutableUserWithAttributes(this);
        }
    }
}

