/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.integration.rest.service.AuthStrategy;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthStrategy
implements AuthStrategy {
    public static String CROWD_APPLICATION_HEADER = "crowd-application-name";
    private static final Logger logger = LoggerFactory.getLogger(OAuth2AuthStrategy.class);
    private final String accessToken;
    private final String applicationName;

    public OAuth2AuthStrategy(String accessToken, String applicationName) {
        this.accessToken = accessToken;
        this.applicationName = applicationName;
    }

    @Override
    public HttpResponse executeRequest(HttpUriRequest request, CloseableHttpClient client, HttpHost httpHost) throws IOException {
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        request.setHeader(CROWD_APPLICATION_HEADER, this.applicationName);
        CloseableHttpResponse response = client.execute(request);
        logger.debug("Response for {} {} was {}", new Object[]{request.getMethod(), request.getURI(), response.getStatusLine()});
        return response;
    }
}

