/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.integration.rest.service.OAuth2AuthStrategy;
import com.atlassian.crowd.integration.rest.service.RestExecutor;
import com.atlassian.crowd.service.client.AuthenticationMethod;
import com.atlassian.crowd.service.client.ClientProperties;
import com.google.common.base.Preconditions;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public class OAuth2RestExecutor
extends RestExecutor {
    public static OAuth2RestExecutor createFrom(ClientProperties clientProperties, CloseableHttpClient httpClient) {
        Preconditions.checkArgument((clientProperties.getAuthenticationMethod() == AuthenticationMethod.OAUTH2 ? 1 : 0) != 0, (Object)"Client properties should specify OAuth2 auth as the authentication method");
        String baseUrl = OAuth2RestExecutor.createBaseUrl(clientProperties.getBaseURL());
        HttpHost httpHost = OAuth2RestExecutor.createHttpHost(clientProperties);
        String accessToken = (String)clientProperties.getApplicationAccessToken().orElseThrow(() -> new IllegalArgumentException("Missing OAuth2 access token"));
        return new OAuth2RestExecutor(baseUrl, httpHost, accessToken, clientProperties.getApplicationName(), httpClient);
    }

    OAuth2RestExecutor(String baseUrl, HttpHost httpHost, String accessToken, String applicationName, CloseableHttpClient client) {
        super(baseUrl, httpHost, new OAuth2AuthStrategy(accessToken, applicationName), client);
    }
}

