/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapNameFactory;
import com.atlassian.crowd.directory.ldap.name.LdapNameFormatException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class ImmutableLdapName
implements Name,
CrowdLdapName {
    private final LdapName ldapName;
    private transient Integer hashCode;

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="No user input")
    protected ImmutableLdapName(String dn) throws LdapNameFormatException {
        try {
            this.ldapName = new LdapName(dn);
        }
        catch (InvalidNameException e) {
            throw new LdapNameFormatException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LdapNameFormatException("Cannot convert DN to an LDAP name: " + dn, e);
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public int compareTo(@Nonnull Object obj) {
        if (!(obj instanceof ImmutableLdapName)) {
            throw new ClassCastException("The obj is not an ImmutableLdapName");
        }
        return this.ldapName.compareTo(((ImmutableLdapName)obj).ldapName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLdapName that = (ImmutableLdapName)o;
        return this.ldapName.equals(that.ldapName);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.ldapName.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.ldapName.toString();
    }

    @Override
    public int size() {
        return this.ldapName.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ldapName.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return this.ldapName.getAll();
    }

    @Override
    public String get(int posn) {
        return this.ldapName.get(posn);
    }

    @Override
    public boolean startsWith(Name n) {
        return this.ldapName.startsWith(n);
    }

    @Override
    public boolean endsWith(Name n) {
        return this.ldapName.endsWith(n);
    }

    @Override
    public ImmutableLdapName toImmutableLdapName() {
        return this;
    }

    @Override
    public List<Rdn> getRdns() {
        return this.ldapName.getRdns();
    }

    @Override
    public Name getPrefix(int posn) {
        List<Rdn> rdns = this.ldapName.getRdns().subList(0, posn);
        return CrowdLdapNameFactory.getInstance().get(rdns).toImmutableLdapName();
    }

    @Override
    public Name getSuffix(int posn) {
        List<Rdn> rdns = this.ldapName.getRdns().subList(posn, this.ldapName.getRdns().size());
        return CrowdLdapNameFactory.getInstance().get(rdns).toImmutableLdapName();
    }

    @Override
    public Name addAll(Name suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name addAll(int posn, Name n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name add(String comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name add(int posn, String comp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int posn) {
        throw new UnsupportedOperationException();
    }
}

