/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.directory.synchronisation.cache.GroupUserCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class LdapFullSyncDetails {
    private final boolean groupsContainUserMembership;
    private final boolean usersContainGroupMembership;
    private final Future<List<LDAPGroupWithAttributes>> groupListFuture;
    private final Future<List<LDAPUserWithAttributes>> userListFuture;

    public LdapFullSyncDetails(boolean groupsContainUserMembership, boolean usersContainGroupMembership, Future<List<LDAPGroupWithAttributes>> groupListFuture, Future<List<LDAPUserWithAttributes>> userListFuture) {
        this.groupsContainUserMembership = groupsContainUserMembership;
        this.usersContainGroupMembership = usersContainGroupMembership;
        this.groupListFuture = groupListFuture;
        this.userListFuture = userListFuture;
    }

    public GroupUserCache toGroupUserCache() throws OperationFailedException {
        return new GroupUserCache(true, this.isGroupsContainUserMembership(), this.isUsersContainGroupMembership(), this.getGroupListFromFuture(), this.getUserListFromFuture());
    }

    public boolean isGroupsContainUserMembership() {
        return this.groupsContainUserMembership;
    }

    public boolean isUsersContainGroupMembership() {
        return this.usersContainGroupMembership;
    }

    public List<LDAPGroupWithAttributes> getGroupListFromFuture() throws OperationFailedException {
        return this.getListFromFuture(this.groupListFuture);
    }

    public List<LDAPUserWithAttributes> getUserListFromFuture() throws OperationFailedException {
        return this.getListFromFuture(this.userListFuture);
    }

    private <E> List<E> getListFromFuture(Future<List<E>> listFuture) throws OperationFailedException {
        try {
            return listFuture.get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)ie);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

