/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model;

import com.atlassian.crowd.embedded.api.Attributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class EntityWithAttributes
implements Attributes {
    private final Map<String, Set<String>> attributes;

    public EntityWithAttributes(Map<String, Set<String>> attributes) {
        this.attributes = Collections.unmodifiableMap(new HashMap<String, Set<String>>(attributes));
    }

    @Nonnull
    public Set<String> getValues(String name) {
        return this.attributes.getOrDefault(name, Collections.emptySet());
    }

    @Nullable
    public String getValue(String name) {
        Set<String> values = this.getValues(name);
        return !values.isEmpty() ? values.iterator().next() : null;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("attributes", this.attributes).toString();
    }
}

