package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertListener;

import javax.annotation.Nonnull;

public interface AlertPublisher {

    /**
     * Publishes an {@link Alert alert} to registered {@link AlertListener listeners}
     *
     * @param alert the alert to publish
     */
    void publish(@Nonnull Alert alert);

    /**
     * Subscribes the provided {@code listener} to all alerts
     *
     * @param listener the listener
     * @return the subscription ID to be used in {@link #unsubscribe}
     */
    @Nonnull
    String subscribe(@Nonnull AlertListener listener);

    /**
     * Unsubscribes the {@link AlertListener} that had previously {@link #subscribe subscribed}.
     *
     * @param subscriptionId the subscription ID returned by {@link #subscribe}
     * @return {@code true} if the listener was unsubscribed, {@code false} if no subscription was found for
     *          {@code subscriptionId}
     */
    boolean unsubscribe(@Nonnull String subscriptionId);
}
