package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertRequest;
import com.atlassian.diagnostics.ComponentMonitor;

import javax.annotation.Nonnull;
import java.time.Duration;

/**
 * Configuration provided by the host application, used to configure atlassian-diagnostics
 */
public interface DiagnosticsConfiguration {

    /**
     * @return the minimum amount of time that {@link Alert alerts} will be kept in the database
     */
    @Nonnull
    Duration getAlertRetentionPeriod();

    /**
     * @return the interval at which {@link Alert alerts} older than {@link #getAlertRetentionPeriod()} are
     *         deleted from the database; in case of a fresh instance (or full cluster) (re-)start, this is also
     *         the initial offset until the truncation is executed for the first time
     */
    @Nonnull
    Duration getAlertTruncationInterval();

    /**
     * @return the name of the current node, used when {@link ComponentMonitor#alert(AlertRequest) raising alerts}
     */
    @Nonnull
    String getNodeName();

    /**
     * @return {@code true} if the diagnostics feature is enabled, otherwise {@code false}
     */
    boolean isEnabled();
}
