package com.atlassian.diagnostics.internal;

import com.atlassian.diagnostics.PageRequest;
import com.atlassian.diagnostics.PageSummary;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Objects.requireNonNull;
import static java.util.Optional.ofNullable;

public class SimplePageSummary implements PageSummary {

    private final PageRequest nextRequest;
    private final PageRequest prevRequest;
    private final int size;

    public SimplePageSummary(PageRequest prevRequest, PageRequest nextRequest, int size) {
        this.prevRequest = prevRequest;
        this.nextRequest = nextRequest;
        this.size = size;
    }

    public SimplePageSummary(@Nonnull PageRequest pageRequest, int size) {
        requireNonNull(pageRequest, "pageRequest");
        this.size = Math.min(size, pageRequest.getLimit());

        int start = pageRequest.getStart();
        int limit = pageRequest.getLimit();
        prevRequest = (start > 0) ? PageRequest.of(Math.max(0, start - limit), limit) : null;
        nextRequest = (size > limit) ? PageRequest.of(start + limit, limit) : null;
    }

    @Nonnull
    @Override
    public Optional<PageRequest> getNextRequest() {
        return ofNullable(nextRequest);
    }

    @Nonnull
    @Override
    public Optional<PageRequest> getPrevRequest() {
        return ofNullable(prevRequest);
    }

    @Override
    public int size() {
        return size;
    }
}
