package com.atlassian.diagnostics.internal.dao;

import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.Component;
import com.atlassian.diagnostics.DiagnosticsConstants;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.Severity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.Instant;

/**
 * The persisted entity which contains all details for an {@link Alert}
 */
public interface AlertEntity {

    /**
     * @return the JSON representation of the alert's details, if available
     */
    @Nullable
    String getDetailsJson();

    /**
     * @return the ID of the persisted entity
     */
    long getId();

    /**
     * @return the {@link Issue#getId() ID} of the alert's issue
     */
    @Nonnull
    String getIssueId();

    /**
     * @return the {@link Component#getId() component ID} of the alert's issue's component
     */
    @Nonnull
    String getIssueComponentId();

    /**
     * @return the {@link Issue#getSeverity() severity} of the alert's issue
     */
    @Nonnull
    Severity getIssueSeverity();

    /**
     * @return the alert's {@link Alert#getNodeName()} node name
     */
    @Nonnull
    String getNodeName();

    /**
     * @return the alert trigger's {@link AlertTrigger#getModule() module}, if available
     */
    @Nullable
    String getTriggerModule();

    /**
     * @return the alert trigger's {@link AlertTrigger#getPluginKey() plugin key},
     *         or {@link DiagnosticsConstants#PLUGIN_NOT_DETECTED_KEY} if no trigger was detected
     */
    @Nonnull
    String getTriggerPluginKey();

    /**
     * @return the alert trigger's {@link AlertTrigger#getPluginVersion()} () plugin version}, if available
     */
    @Nullable
    String getTriggerPluginVersion();

    /**
     * @return the alert's {@link Alert#getTimestamp()}
     */
    @Nonnull
    Instant getTimestamp();
}
