package com.atlassian.diagnostics.internal.backdoor.rest;

import com.atlassian.diagnostics.internal.backdoor.DataService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.resource.Singleton;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.time.Instant;

@AnonymousAllowed
@Consumes(MediaType.APPLICATION_JSON)
@Path("/")
@Produces(MediaType.APPLICATION_JSON + ";charset=UTF-8")
@Singleton
public class DataResource {

    private final DataService dataService;

    public DataResource(DataService dataService) {
        this.dataService = dataService;
    }

    @POST
    @Path("generate")
    public Response generateTestAlerts() {
        Instant instant = dataService.createTestData();
        return Response.ok(ImmutableMap.of("latestTimestamp", instant.toString())).build();
    }
}
