package com.atlassian.diagnostics.internal.platform.analytics.ram;

import com.atlassian.diagnostics.internal.platform.analytics.EventFactory;

import javax.annotation.Nonnull;

public abstract class LowRamEventFactory implements EventFactory {

    public LowRamAnalyticsEvent create(@Nonnull final Long freeMemoryInMegabytes,
                                          @Nonnull final Long totalMemoryInMegabytes,
                                          @Nonnull final Long minMemoryThresholdInMegabytes) {
        return new LowRamAnalyticsEvent(freeMemoryInMegabytes, totalMemoryInMegabytes, minMemoryThresholdInMegabytes);
    }

    public static LowRamEventFactory defaultFactory() {
        return new LowRamEventFactory() {
            @Override
            public LowRamAnalyticsEvent create(@Nonnull final Long freeMemoryInMegabytes, @Nonnull final Long totalMemoryInMegabytes, @Nonnull final Long minMemoryThresholdInMegabytes) {
                return super.create(freeMemoryInMegabytes, totalMemoryInMegabytes, minMemoryThresholdInMegabytes);
            }
        };
    }
}
