package com.atlassian.diagnostics.internal.platform.monitor.db;

import java.sql.Connection;
import java.sql.SQLException;

public interface DatabaseDiagnosticsCollector {

    /**
     * @return returns true if diagnostics collection is enabled.
     */
    boolean isEnabled();

    /**
     * Track this connection and raise an alert if abandoned by the caller.
     *
     * @param connection the connection to monitor.
     */
    void trackConnection(Connection connection);

    /**
     * Remove connection from tracking.
     *
     * @param connection the connection being tracked
     */
    void removeTrackedConnection(final Connection connection);

    /**
     * Wraps the {@link SqlOperation} in timings using System.nanoTime() for timings.
     *
     * @param operation is the wrapped database operation
     * @param sql is the SQL query string
     * @param <T> is the type returned from the database operation
     * @return the result of the database operation
     * @throws SQLException if the operation failed to execute
     */
    <T> T recordExecutionTime(final SqlOperation<T> operation, final String sql) throws SQLException;
}
