package com.atlassian.diagnostics.internal.platform.monitor.event;

import com.atlassian.diagnostics.AlertTrigger;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.time.Duration;
import java.util.Optional;

import static java.util.Optional.empty;

public interface EventSystemMonitorConfig {

    /**
     * @return the maximum time the provided event listener is allowed to take to process an event before an alert is
     *         raised
     */
    @Nonnull
    Duration getSlowListenerAlertDuration(@Nullable AlertTrigger trigger);

    /**
     * @return the minimum time that should elapse between generating thread dumps for events being dropped.
     * This is typically quite a costly alert to generate thread dumps for as it will include the stack trace of the
     * current invoker threads and so should be limited in frequency.
     */
    @Nonnull
    Duration getEventDroppedAlertThreadDumpCoolDown();

    /**
     * @return the event dispatcher thread group
     */
    @Nonnull
    default Optional<ThreadGroup> getEventThreadGroup() {
        return empty();
    }
}
