package com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.cpu;

import java.util.Objects;

public class HighCPUUsageEvent {
    private final double percentage;

    public HighCPUUsageEvent(final double percentage) {
        this.percentage = percentage;
    }

    public double getPercentage() {
        return percentage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HighCPUUsageEvent that = (HighCPUUsageEvent) o;
        return Double.compare(that.percentage, percentage) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(percentage);
    }
}
