package com.atlassian.diagnostics.internal.platform.monitor.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;

import java.util.Optional;

public class ScheduledJobDiagnostic {

    private final JobDetails jobDetails;
    private final Optional<RunDetails> lastRun;
    private final Optional<JobRunner> jobRunner;

    public ScheduledJobDiagnostic(final JobDetails jobDetails,
                                  final Optional<RunDetails> lastRun,
                                  final Optional<JobRunner> jobRunner) {
        this.jobDetails = jobDetails;
        this.lastRun = lastRun;
        this.jobRunner = jobRunner;
    }

    public JobDetails getJobDetails() {
        return jobDetails;
    }

    public Optional<RunDetails> getLastRun() {
        return lastRun;
    }

    public Optional<JobRunner> getJobRunner() {
        return jobRunner;
    }
}
