package com.atlassian.diagnostics.internal.platform.monitor.scheduler;

import java.util.List;

public class SchedulerDiagnostic {

    private final int workerThreads;
    private final List<RunningJobDiagnostic> runningJobs;
    private final List<ScheduledJobDiagnostic> scheduledJobs;

    public SchedulerDiagnostic(final int workerThreads,
                               final List<RunningJobDiagnostic> runningJobs,
                               final List<ScheduledJobDiagnostic> scheduledJobs) {
        this.workerThreads = workerThreads;
        this.runningJobs = runningJobs;
        this.scheduledJobs = scheduledJobs;
    }

    public int getWorkerThreads() {
        return workerThreads;
    }

    public List<RunningJobDiagnostic> getRunningJobs() {
        return runningJobs;
    }

    public List<ScheduledJobDiagnostic> getScheduledJobs() {
        return scheduledJobs;
    }

}
