/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.db;

import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseDiagnosticsCollector;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseMonitor;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseMonitorConfiguration;
import com.atlassian.diagnostics.internal.platform.monitor.db.DatabaseOperationDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.SqlOperation;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.DatabasePoolDiagnostic;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.DatabasePoolDiagnosticProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseDiagnosticsCollector
implements DatabaseDiagnosticsCollector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDatabaseDiagnosticsCollector.class);
    private final DatabaseMonitorConfiguration configuration;
    private final DatabasePoolDiagnosticProvider poolDiagnosticProvider;
    private final Duration poolConnectionLeakTimeout;
    private final DatabaseMonitor databaseMonitor;
    private final Clock clock;
    private final Cache<Connection, Instant> connectionCache;

    public DefaultDatabaseDiagnosticsCollector(@Nonnull DatabaseMonitorConfiguration configuration, @Nonnull DatabasePoolDiagnosticProvider poolDiagnosticProvider, @Nonnull Clock clock, @Nonnull DatabaseMonitor databaseMonitor) {
        this.configuration = configuration;
        this.poolDiagnosticProvider = poolDiagnosticProvider;
        this.databaseMonitor = databaseMonitor;
        this.poolConnectionLeakTimeout = configuration.poolConnectionLeakTimeout();
        this.clock = clock;
        this.connectionCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).expireAfterAccess(this.poolConnectionLeakTimeout).removalListener((RemovalListener)new LeakedConnectionListener()).build();
    }

    @Override
    public boolean isEnabled() {
        return this.configuration.isEnabled();
    }

    @Override
    public void trackConnection(Connection connection) {
        if (this.poolConnectionLeakTimeout.compareTo(Duration.ZERO) > 0) {
            this.connectionCache.put((Object)connection, (Object)this.clock.instant());
        }
    }

    @Override
    public void removeTrackedConnection(Connection connection) {
        if (this.poolConnectionLeakTimeout.compareTo(Duration.ZERO) > 0) {
            this.connectionCache.invalidate((Object)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordExecutionTime(SqlOperation<T> operation, String sql) throws SQLException {
        long startTime = System.currentTimeMillis();
        try {
            T t = operation.execute();
            return t;
        }
        finally {
            try {
                Duration duration = Duration.ofMillis(System.currentTimeMillis() - startTime);
                this.raiseAlertIfExecutionExceededThreshold(sql, duration);
            }
            catch (Exception e) {
                logger.debug("Failed to raise alert", (Throwable)e);
            }
        }
    }

    private void raiseAlertIfExecutionExceededThreshold(String sql, Duration duration) {
        if (duration.compareTo(this.configuration.longRunningOperationLimit()) >= 0) {
            DatabaseOperationDiagnostic diagnostic = new DatabaseOperationDiagnostic(sql, duration, Thread.currentThread().getName());
            this.databaseMonitor.raiseAlertForSlowOperation(Instant.now(), diagnostic);
        }
    }

    private class LeakedConnectionListener
    implements RemovalListener<Connection, Instant> {
        private LeakedConnectionListener() {
        }

        public void onRemoval(RemovalNotification<Connection, Instant> notification) {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                DefaultDatabaseDiagnosticsCollector.this.poolDiagnosticProvider.getDiagnostics().ifPresent(diagnostic -> DefaultDatabaseDiagnosticsCollector.this.databaseMonitor.raiseAlertForConnectionLeak(DefaultDatabaseDiagnosticsCollector.this.clock.instant(), (Instant)notification.getValue(), (DatabasePoolDiagnostic)diagnostic));
            }
        }
    }
}

