/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JmxDatabasePoolAttributes {
    APACHE_COMMONS("org.apache.commons.pool2.impl.GenericObjectPool", PoolAttributeBuilder.access$300(PoolAttributeBuilder.access$200(PoolAttributeBuilder.access$100(PoolAttributeBuilder.access$000(), "NumIdle"), "NumActive"), "MaxTotal").build(), "RemoveAbandonedTimeout"),
    TOMCAT("org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool", PoolAttributeBuilder.access$300(PoolAttributeBuilder.access$200(PoolAttributeBuilder.access$100(PoolAttributeBuilder.access$000(), "NumIdle"), "NumActive"), "MaxTotal").build(), "RemoveAbandonedTimeout"),
    VIBUR("org.vibur.dbcp.ViburDBCPMonitoring", PoolAttributeBuilder.access$300(PoolAttributeBuilder.access$200(PoolAttributeBuilder.access$100(PoolAttributeBuilder.access$000(), "PoolRemainingCreated"), "PoolTaken"), "PoolMaxSize").build()),
    HIKARI("com.zaxxer.hikari.pool.HikariPool", PoolAttributeBuilder.access$300(PoolAttributeBuilder.access$200(PoolAttributeBuilder.access$100(PoolAttributeBuilder.access$000(), "IdleConnections"), "ActiveConnections"), "TotalConnections").build());

    public static final int IDLE_CONNECTION_ATTRIBUTE_INDEX = 0;
    public static final int ACTIVE_CONNECTION_ATTRIBUTE_INDEX = 1;
    public static final int MAX_CONNECTION_ATTRIBUTE_INDEX = 2;
    private static final Logger logger;
    public final String instanceOfQuery;
    public final String[] poolUseAttributeNames;
    public final String abandonedTimeoutAttributeName;

    private JmxDatabasePoolAttributes(String instanceOfQuery, String[] poolUseAttributeNames) {
        this(instanceOfQuery, poolUseAttributeNames, "");
    }

    private JmxDatabasePoolAttributes(String instanceOfQuery, String[] poolUseAttributeNames, String abandonedTimeoutAttributeName) {
        this.instanceOfQuery = instanceOfQuery;
        this.poolUseAttributeNames = poolUseAttributeNames;
        this.abandonedTimeoutAttributeName = abandonedTimeoutAttributeName;
    }

    public List<Attribute> getJmxAttributes(@Nonnull MBeanServer beanServer, @Nonnull ObjectInstance objectInstance) {
        try {
            return beanServer.getAttributes(objectInstance.getObjectName(), this.poolUseAttributeNames).asList();
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            logger.debug("Failed to get jmxAttributes for {}", (Object)objectInstance);
            return Collections.emptyList();
        }
    }

    static {
        logger = LoggerFactory.getLogger(JmxDatabasePoolAttributes.class);
    }

    private static class PoolAttributeBuilder {
        private String idleConnections;
        private String activeConnections;
        private String maxConnections;

        private static PoolAttributeBuilder builder() {
            return new PoolAttributeBuilder();
        }

        private PoolAttributeBuilder() {
        }

        private PoolAttributeBuilder idleConnectionsAttribute(String idleConnections) {
            this.idleConnections = idleConnections;
            return this;
        }

        private PoolAttributeBuilder activeConnectionsAttribute(String activeConnections) {
            this.activeConnections = activeConnections;
            return this;
        }

        private PoolAttributeBuilder maxConnectionsAttribute(String maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public String[] build() {
            return new String[]{this.idleConnections, this.activeConnections, this.maxConnections};
        }

        static /* synthetic */ PoolAttributeBuilder access$000() {
            return PoolAttributeBuilder.builder();
        }

        static /* synthetic */ PoolAttributeBuilder access$100(PoolAttributeBuilder x0, String x1) {
            return x0.idleConnectionsAttribute(x1);
        }

        static /* synthetic */ PoolAttributeBuilder access$200(PoolAttributeBuilder x0, String x1) {
            return x0.activeConnectionsAttribute(x1);
        }

        static /* synthetic */ PoolAttributeBuilder access$300(PoolAttributeBuilder x0, String x1) {
            return x0.maxConnectionsAttribute(x1);
        }
    }
}

