/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver;

import com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver.JmxDatabasePoolAttributes;
import com.atlassian.diagnostics.internal.platform.monitor.db.pool.resolver.JmxDatabasePoolBean;
import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.Query;

public class JmxDatabasePoolBeanResolver {
    private Optional<JmxDatabasePoolBean> jmxDatabasePoolBean = Optional.empty();

    public Optional<JmxDatabasePoolBean> getDatabaseConnectionPool() {
        if (!this.jmxDatabasePoolBean.isPresent()) {
            this.jmxDatabasePoolBean = EnumSet.allOf(JmxDatabasePoolAttributes.class).stream().map(jmx -> this.getDbPoolJmxInfo(ManagementFactory.getPlatformMBeanServer(), (JmxDatabasePoolAttributes)((Object)jmx))).filter(Optional::isPresent).findAny().orElse(Optional.empty());
        }
        return this.jmxDatabasePoolBean;
    }

    private Optional<JmxDatabasePoolBean> getDbPoolJmxInfo(MBeanServer beanServer, JmxDatabasePoolAttributes jmx) {
        Set<ObjectInstance> jmxObjectInstances = beanServer.queryMBeans(null, Query.isInstanceOf(Query.value(jmx.instanceOfQuery)));
        if (jmxObjectInstances.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JmxDatabasePoolBean(jmx, jmxObjectInstances.iterator().next()));
    }
}

